 ; Ŀ
 ;   NafF - make cable names fit in tag boxes.                             
 ;   Copyright 1997, 2000, 2001, 2006, 2008, 2009 by Rocket Software Ltd.  
 ;   Has to be able to find Puss.lsp.                                      
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Bowo - find the width of a block.                          
 ;   Argument: enam, a block insertion ename.                              
 ;   Calls Bent, so the file puss.lsp must be available.                   
 ;   Returns a distance.                                                   
 ; 
 (DEFUN BOWO (enam / blnam plist pta rhdis lhdis)
  (setq blnam (cdr (assoc 2 (entget enam))))
 ; Ŀ
 ;   Load the block corner point finder from Puss.lsp.                     
 ; 
  (if (not bent) (load "puss"))
 ; Ŀ
 ;   Get a list of the insertion point and block extents.                  
 ;   Bent returns a list: (insertion_point  x-max  x-min  y-max  y-min).   
 ; 
  (setq plist (bent blnam))
  (setq pta (car plist))
  (setq rhdis (+ (car pta) (cadr plist)))         ; right hand (+x) distance
  (setq lhdis (abs (+ (car pta) (caddr plist))))  ; left hand (-x) distance
 (+ rhdis lhdis))
 ; Ŀ
 ;   Bowo end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Cresh - squeeze or stretch attributes as required.         
 ;   Arguments: Enam, an attribute ename.                                  
 ;              Widd, the allowable actual width, without end gaps.        
 ;              Ideal, the ideal desired width scale factor.               
 ; 
 (DEFUN CRESH (enam widd ideal / entt realwd widscl prev41 widd scalfc)
  (setq entt (entget enam))
 ; Ŀ
 ;   Call Wits to find the actual string width.                            
 ; 
  (setq realwd (wits entt))
 ; Ŀ
 ;   Find the attribute width scale factor.                                
 ; 
  (setq widscl (cdr (setq prev41 (assoc 41 entt))))
 ; Ŀ
 ;   Compare the actual and desired widths.                                
 ;   If the actual width is greater than the space then crush the          
 ;   attribute to fit.                                                     
 ; 
  (cond ((> realwd widd)
         (setq scalfc (/ widd realwd))
         (setq widscl (* widscl scalfc))
         (entmod (subst (cons 41 widscl) prev41 entt)))
 ; Ŀ
 ;   Should see if the width scale is greater than ideal - if so then      
 ;   set it to ideal.                                                      
 ;   The previous condition checked to see if it was too wide, so don't    
 ;   have to do that here.                                                 
 ;   This should only happen if someone has done something odd.            
 ; 
        ((> widscl ideal)
         (entmod (subst (cons 41 ideal) prev41 entt)))
 ; Ŀ
 ;   See if the attribute is narrower than it should be.                   
 ;   If setting the width scale factor to the desired value would leave    
 ;   the attibute wider than the allowable space, then increase it just    
 ;   to fill the space.                                                    
 ; 
        ((< widscl ideal)
         (if (> (* realwd (/ ideal widscl)) widd)
                (progn
                     (setq scalfc (/ widd realwd))
                     (setq widscl (* widscl scalfc))
                     (entmod (subst (cons 41 widscl) prev41 entt)))
 ; Ŀ
 ;   Otherwise set it to the ideal width scale value.                      
 ; 
                (entmod (subst (cons 41 ideal) prev41 entt)))))
 (princ))
 ; Ŀ
 ;   Cresh end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Cstar - draw an individual grstar (centred).               
 ;   Takes four arguments: centre point, side length, rotation (radians),  
 ;   and colour.  Returns nothing, but draws a star.                       
 ; 
 (DEFUN CSTAR (pa sidlen rota colo / anginc angg hafang pb)
  (setq pa (polar pa (+ rota (/ pi 2)) (* sidlen 1.37638192)))
  (setq anginc (* 1.6 pi))
  (setq angg (+ rota (* 1.6 pi)))
  (setq hafang (* 0.8 pi))
  (repeat 5
         (setq pb (polar pa angg sidlen))
         (grdraw pa pb colo)
         (setq angg (- angg anginc))
         (setq pa pb)
         (setq pb (polar pa angg sidlen))
         (grdraw pa pb colo)
         (setq angg (- angg hafang))
         (setq pa pb))
 (princ))
 ; Ŀ
 ;   Subroutine Cstar end.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Wits - find the width of an attribute.                     
 ;   Takes one argument: the attribute entity data list.  Returns a width. 
 ; 
 (DEFUN WITS (entt / tblist cc dd bwidth)
  (setq tblist (textbox entt))
  (setq cc (car tblist))                    ; ll offset from 10 of text
  (setq dd (cadr tblist))                   ; ur offset from 10 of text
  (setq bwidth (- (car dd) (car cc))))
 ; Ŀ
 ;   Wits end.                                                             
 ; 

 ; Ŀ
 ;   Naff.                                                                 
 ; 
 (DEFUN C:NAFF (/ snapp *error* ss num enam esav bxwid)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "snapmode" snapp)
   (command "undo" "end")
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   Get an ss of block inserts with attributes.                           
 ; 
  (setq ss (ssget '((0 . "insert") (66 . 1))))
 ; Ŀ
 ;   For each one...                                                       
 ; 
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq esav enam)
         (setq num (1+ num))
 ; Ŀ
 ;   Find the space available in the block.                                
 ; 
         (setq bscal (cdr (assoc 41 (entget enam))))
         (setq bxwid (* bscal (bowo enam)))
         (setq bxwid (- bxwid (* bscal 3)))  ; allow for end gaps
 ; Ŀ
 ;   Adjust the attribute width.                                           
 ; 
         (setq enam (entnext enam))
         (cresh enam bxwid 1.0)
         (entupd esav))
 ; Ŀ
 ;   End neatly.                                                           
 ; 
  (*error* ())
 (princ))